<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<?php
// Kết nối đến cơ sở dữ liệu
$servername = "localhost";
$username = "nhaxinhd_wp483";
$password = "6d0oO-Sp1-";
$dbname = "nhaxinhd_wp483";

$conn = new mysqli($servername, $username, $password, $dbname);
// Kiểm tra kết nối
if ($conn->connect_error) {
  die("Kết nối không thành công: " . $conn->connect_error);
}
// Thiết lập charset utf8
$conn->set_charset("utf8");

// Thực thi câu truy vấn
$sql = "
SELECT 
    t.id AS task_id,
    s.staffid,
    CONCAT(s.firstname, ' ', s.lastname) AS staff_name,
    c.company AS client_company,
    t.dateadded AS task_date,
    cf_mooc.value AS mooc,
    cf_diem_di.value AS diem_di,
    cf_diem_den.value AS diem_den,
    cf_so_cont.value AS so_cont,
    cf_phu_cap.value AS phu_cap,
    cf_phu_cap_cap.value AS phu_cap_cap,
    cf_phu_cap_neo.value AS phu_cap_neo,
    cf_phu_cap_lanh.value AS phu_cap_lanh,
    cf_phu_cap_khac.value AS phu_cap_khac,
    cf_tien_ung.value AS tien_ung,
    cf_luong.value AS luong,
    cf_quyet_toan.value AS quyet_toan
FROM 
    tbltasks AS t
JOIN 
    tbltask_assigned AS ta ON t.id = ta.taskid
JOIN 
    tblstaff AS s ON ta.staffid = s.staffid
LEFT JOIN 
    tblclients AS c ON t.rel_id = c.userid
LEFT JOIN 
    tblcustomfieldsvalues AS cf_mooc ON t.id = cf_mooc.relid AND cf_mooc.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_mooc')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_diem_di ON t.id = cf_diem_di.relid AND cf_diem_di.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_diem_di')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_diem_den ON t.id = cf_diem_den.relid AND cf_diem_den.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_diem_den')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_so_cont ON t.id = cf_so_cont.relid AND cf_so_cont.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_so_cont')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_phu_cap ON t.id = cf_phu_cap.relid AND cf_phu_cap.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_phu_cap')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_phu_cap_cap ON t.id = cf_phu_cap_cap.relid AND cf_phu_cap_cap.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_phu_cap_cap')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_phu_cap_neo ON t.id = cf_phu_cap_neo.relid AND cf_phu_cap_neo.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_phu_cap_neo')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_phu_cap_lanh ON t.id = cf_phu_cap_lanh.relid AND cf_phu_cap_lanh.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_phu_cap_lanh')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_phu_cap_khac ON t.id = cf_phu_cap_khac.relid AND cf_phu_cap_khac.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_phu_cap_khac')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_tien_ung ON t.id = cf_tien_ung.relid AND cf_tien_ung.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_tien_ung')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_luong ON t.id = cf_luong.relid AND cf_luong.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_luong')
LEFT JOIN 
    tblcustomfieldsvalues AS cf_quyet_toan ON t.id = cf_quyet_toan.relid AND cf_quyet_toan.fieldid = (SELECT id FROM tblcustomfields WHERE slug = 'tasks_quyet_toan')
    ";
$result = $conn->query($sql);

// Hàm tính tổng ứng
function calculate_total_advance($tasks) {
    $total_advance = 0;
    foreach ($tasks as $task) {
        $total_advance += (float)$task['tien_ung'];
    }
    return $total_advance;
}

// Hàm tính tổng quyết toán
function calculate_total_settlement($tasks) {
    $total_settlement = 0;
    foreach ($tasks as $task) {
        $total_settlement += (float)$task['quyet_toan'];
    }
    return $total_settlement;
}

// Dữ liệu đã xử lý
$tasks_by_staff = [];
while ($row = $result->fetch_assoc()) {
    $staff_name = $row['staff_name'];
    if (!isset($tasks_by_staff[$staff_name])) {
        $tasks_by_staff[$staff_name] = [
            'tasks' => [],
            'total_ung_amount' => 0,
            'total_quyet_toan' => 0
        ];
    }
    $tasks_by_staff[$staff_name]['tasks'][] = $row;
    // Tính tổng ứng cho nhân viên này
    $tasks_by_staff[$staff_name]['total_ung_amount'] = calculate_total_advance($tasks_by_staff[$staff_name]['tasks']);
    // Tính tổng quyết toán cho nhân viên này
    $tasks_by_staff[$staff_name]['total_quyet_toan'] = calculate_total_settlement($tasks_by_staff[$staff_name]['tasks']);
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Task Summary</title>
    <style>
        /* Thêm CSS để tạo các tab */
        .tab {
            overflow: hidden;
            border: 1px solid #ccc;
        }
    
        .tab button {
            background-color: inherit;
            float: left;
            border: none;
            outline: none;
            cursor: pointer;
            padding: 14px 16px;
            transition: 0.3s;
        }
    
        .tab button:hover {
            background-color: #ddd;
        }
    
        .tab button.active {
            background-color: #ccc;
        }
    
        .tabcontent {
            display:
            none;
            padding: 6px 12px;
            border-top: none;
        }
    </style>
</head>
<body>
    <div id="wrapper">
        <div class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="panel_s tw-mt-2 sm:tw-mt-4">
                        <div class="panel-body">
                            <div class="panel-table-full">
                                <div id="clients_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">
                                    <div class="tab">
                                        <?php foreach ($tasks_by_staff as $index => $staff): ?>
                                            <button class="tablinks" data-tab="Tab<?php echo $index; ?>"><?php echo $index; ?></button>
                                        <?php endforeach; ?>
                                    </div>
                                    <div class="table-responsive">
                                        <?php foreach ($tasks_by_staff as $index => $staff): ?>
                                            <div id="Tab<?php echo $index; ?>" class="tabcontent">
                                                <h3 style="text-align:center"><?php echo $index; ?></h3>
                                                <p style="text-align:center">Details for <?php echo $index; ?>...</p>
                                                <button onclick="exportToPDF()">Xuất PDF</button>
    <button onclick="exportToExcel()">Xuất Excel</button>
                                                <table id="myTable" border='1' class="table table-clients number-index-2 dataTable no-footer">
                                                    <thead>
                                                        <tr rple="row">
                                                            <th>Task ID</th>
                                                            <th>Staff Name</th>
                                                            <th>Client Company</th>
                                                            <th>Task Date</th>
                                                            <th>Mooc</th>
                                                            <th>Điểm Đi</th>
                                                            <th>Điểm Đến</th>
                                                            <th>Số Cont</th>
                                                            <th>Lương Chuyến</th>
                                                            <th>Phụ Cấp</th>
                                                            <th>Phụ Cấp Cặp</th>
                                                            <th>Phụ Cấp Neo</th>
                                                            <th>Phụ Cấp Lạnh</th>
                                                            <th>Phụ Cấp Khác</th>
                                                            <th>Tiền Ứng</th>
                                                            <th>Quyết Toán</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($staff['tasks'] as $task): ?>
                                                            <tr>
                                                                <td><?php echo $task["task_id"]; ?></td>
                                                                <td><?php echo $task["staff_name"]; ?></td>
                                                                <td><?php echo $task["client_company"]; ?></td>
                                                                <td><?php echo $task["task_date"]; ?></td>
                                                                <td><?php echo $task["mooc"]; ?></td>
                                                                <td><?php echo $task["diem_di"]; ?></td>
                                                                <td><?php echo $task["diem_den"]; ?></td>
                                                                <td><?php echo $task["so_cont"]; ?></td>
                                                                <td><?php echo $task["luong"]; ?></td>
                                                                <td><?php echo $task["phu_cap"]; ?></td>
                                                                <td><?php echo $task["phu_cap_cap"]; ?></td>
                                                                <td><?php echo $task["phu_cap_neo"]; ?></td>
                                                                <td><?php echo $task["phu_cap_lanh"]; ?></td>
                                                                <td><?php echo $task["phu_cap_khac"]; ?></td>
                                                                <td><?php echo $task["tien_ung"]; ?></td>
                                                                <td><?php echo $task["quyet_toan"]; ?></td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                                <div class="col-md-4 col-md-offset-8">
                                        <table class="table text-right">
                                            <tbody>
                                            <tr id="subtotal">
                                                <td><span class="bold"><?php echo _l('Tổng Ứng'); ?> :</span>
                                                </td>
                                                <td class="total_capacity">
                                                <?php echo $staff['total_ung_amount']; ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><span class="bold"><?php echo _l('Quyết Toán'); ?> :</span>
                                                </td>
                                                <td class="total_estimated_time">
                                                <strong><?php echo $staff['total_quyet_toan']; ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><span class="bold"><?php echo _l('Hoàn Ứng'); ?> :</span>
                                                </td>
                                                <td class="total_spent_time">                                      
                                                <strong><?php echo $staff['total_ung_amount'] - $staff['total_quyet_toan']; ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><span class="bold"><?php echo _l('Lương'); ?> :</span>
                                                </td>
                                                <td class="total_available_cap">                                      
                                                <?php echo round(($data_workload['data_total']['capacity'] - $data_workload['data_total']['estimate']), 2); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><span class="bold"><?php echo _l('Tổng Lương'); ?> :</span>
                                                </td>
                                                <td class="total_available_cap">                                      
                                                <?php echo round(($data_workload['data_total']['capacity'] - $data_workload['data_total']['estimate']), 2); ?>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            function openTab(evt, tabName) {
                var i, tabcontent, tablinks;
                tabcontent = document.getElementsByClassName("tabcontent");
                for (i = 0; i < tabcontent.length; i++) {
                    tabcontent[i].style.display = "none";
                }
                tablinks = document.getElementsByClassName("tablinks");
                for (i = 0; i < tablinks.length; i++) {
                    tablinks[i].classList.remove("active");
                }
                var tabElement = document.getElementById(tabName);
                if (tabElement) {
                    tabElement.style.display = "block";
                    evt.currentTarget.classList.add("active");
                }
            }

            var tablinks = document.getElementsByClassName("tablinks");
            for (var i = 0; i < tablinks.length; i++) {
                tablinks[i].addEventListener("click", function(event) {
                    var tabName = this.getAttribute("data-tab");
                    openTab(event, tabName);
                });
            }

            if (tablinks.length > 0) {
                tablinks[0].click();
            }
        });
    </script>
      <script>
        async function exportToPDF() {
            const { jsPDF } = window.jspdf;

            // Lấy nội dung của bảng
            const table = document.getElementById('myTable');
            const canvas = await html2canvas(table);
            const imgData = canvas.toDataURL('image/png');

            // Tạo đối tượng jsPDF
            const pdf = new jsPDF();

            // Thêm ảnh của bảng vào PDF
            pdf.addImage(imgData, 'PNG', 10, 10, canvas.width / 4, canvas.height / 4);
            pdf.save('table.pdf');
        }
    </script>
     <script>
      function exportToExcel() {
          // Lấy bảng HTML
          var table = document.getElementById('myTable');
          var wb = XLSX.utils.table_to_book(table, { sheet: "Sheet JS" });

          // Xuất file Excel
          XLSX.writeFile(wb, 'table.xlsx');
      }
  </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.5/xlsx.full.min.js"></script>
</body>
</html>
<?php init_tail(); ?>