<?php

defined('BASEPATH') or exit('No direct script access allowed');



class Congno extends AdminController

{

    public function __construct()

    {

        parent::__construct();

        $this->load->model('congno_model');

    }



    public function index()

    {

        $staff_id = get_staff_user_id();

        $staff = $this->staff_model->get($staff_id);

        $role = $staff->role;

        $data['status'] = $this->congno_model->get_status();

        $data['clients'] = $this->congno_model->get_clients();

        $data['congno_data'] = $this->congno_model->get_congno_data();

        $data['staff'] = $this->congno_model->get_staff_data();

        $data['xenha'] = $this->congno_model->get_xenha();

        if ($role == 4) {

            foreach ($data['congno_data'] as &$row) {

                $row['Gia_van_chuyen'] = 0;

            }

            $data['hide_shipping_cost'] = true;

        } else {

            $data['hide_shipping_cost'] = false;

        }

        $this->load->view('manage', $data);

    }

    public function get_congno($id)

    {

        $congno = $this->congno_model->get_congno_by_id($id);

        echo json_encode($congno);

    }

    public function get_xenha($id)

    {

        $xenha = $this->congno_model->get_xenha_by_id($id);

        echo json_encode($xenha);

    }

    public function insert_congno(){

        $data = $this->input->post();

        $this->congno_model->insert_congno($data);

        redirect('congno/index');

    }

    public function update_congno()

    {

        $id = $this->input->post('id');

        $data = $this->input->post();

        $this->congno_model->update_congno_data($id, $data);

        echo json_encode(['status' => 'success']);

    }



    public function delete($id)

    {

        $this->congno_model->delete_congno($id);

        redirect('congno/index');

    }

    public function update_row_color()

    {

        $id = $this->input->post('id');

        $color = $this->input->post('color');

    

        $this->congno_model->update_field($id, 'note_color', $color);

        $csrf_hash = $this->security->get_csrf_hash(); // Lấy mã thông báo CSRF mới

    

        echo json_encode(['status' => 'success', 'csrfHash' => $csrf_hash]);

    }

    

    public function delete_selected()

    {

        $selectedIds = $this->input->post('ids');

        foreach ($selectedIds as $id) {

            $this->congno_model->delete_congno($id);

        }



        $response = ['status' => 'success'];

        echo json_encode($response);

    }

    

    

}