
const exportBtn = document.getElementById('export-btn');
const exportMenu = document.getElementById('export-menu');
const togglefilter = document.getElementById('toggleFilterBtn');
const filterForm = document.getElementById('filterContainer');
exportBtn.addEventListener('click', function () {
    exportMenu.style.display = exportMenu.style.display === 'none' ?
        'block' : 'none';
});
togglefilter.addEventListener('click', function () {
    filterForm.classList.toggle('show');
})
document.addEventListener('click', function (event) {
    const isClickInsideExportBtn = exportBtn.contains(event.target);
    const isClickInsideExportMenu = exportMenu.contains(event
        .target);

    if (!isClickInsideExportBtn && !isClickInsideExportMenu) {
        exportMenu.style.display = 'none';
    }
});
document.addEventListener('click', function (event) {
    const isClickInsideFilterBtn = togglefilter.contains(event
        .target);
    const isClickInsideFilterForm = filterForm.contains(event
        .target);
    if (!isClickInsideFilterBtn && !isClickInsideFilterForm) {
        filterForm.classList.remove('show');
    }
});


document.addEventListener("DOMContentLoaded", function () {
    // Set default month to the current month
    var currentMonth = ("0" + (new Date().getMonth() + 1)).slice(-2);
    document.getElementById("filter_Thang").value = currentMonth;

    // Trigger the filter function on page load
    filterTable();
});

function filterTable() {
    var filterMAKH = document.getElementById("filter_MA_KH").value.toUpperCase();
    var filterSoCont = document.getElementById("filter_So_cont").value.toUpperCase();
    var filterNgayGhiSo = document.getElementById("filter_Ngay_ghi_so").value.toUpperCase();
    var filterThang = document.getElementById("filter_Thang").value;

    var table = document.getElementById("myTable");
    var tr = table.getElementsByTagName("tr");

    for (var i = 1; i < tr.length; i++) {
        var tdMAKH = tr[i].getElementsByTagName("td")[1];
        var tdSoCont = tr[i].getElementsByTagName("td")[3];
        var tdNgayGhiSo = tr[i].getElementsByTagName("td")[2];

        if (tdMAKH && tdSoCont && tdNgayGhiSo) {
            var txtValueMAKH = tdMAKH.textContent || tdMAKH.innerText;
            var txtValueSoCont = tdSoCont.textContent || tdSoCont.innerText;
            var txtValueNgayGhiSo = tdNgayGhiSo.textContent || tdNgayGhiSo.innerText;

            var date = new Date(txtValueNgayGhiSo);
            var month = ("0" + (date.getMonth() + 1)).slice(-2);

            if ((txtValueMAKH.toUpperCase().indexOf(filterMAKH) > -1 || filterMAKH === "") &&
                (txtValueSoCont.toUpperCase().indexOf(filterSoCont) > -1 || filterSoCont === "") &&
                (txtValueNgayGhiSo.toUpperCase().indexOf(filterNgayGhiSo) > -1 || filterNgayGhiSo === "") &&
                (month === filterThang || filterThang === "")) {
                tr[i].style.display = "";
            } else {
                tr[i].style.display = "none";
            }
        }
    }
}

function searchTable() {
    let input = document.getElementById('searchInput').value.toLowerCase();
    let table = document.getElementById('myTable');
    let trs = table.getElementsByTagName('tr');

    for (let i = 1; i < trs.length; i++) {
        let tds = trs[i].getElementsByTagName('td');
        let rowContainsSearchTerm = false;

        for (let j = 0; j < tds.length; j++) {
            if (tds[j].innerText.toLowerCase().includes(input)) {
                rowContainsSearchTerm = true;
                break;
            }
        }

        if (rowContainsSearchTerm) {
            trs[i].style.display = "";
        } else {
            trs[i].style.display = "none";
        }
    }
}

function updateFilters() {
    let maKHSelect = document.getElementById('filter_MA_KH');
    let soContSelect = document.getElementById('filter_So_cont');
    let ngayGhiSoSelect = document.getElementById('filter_Ngay_ghi_so');
    let table = document.getElementById('myTable');
    let trs = table.getElementsByTagName('tr');

    let soContOptions = new Set();
    let ngayGhiSoOptions = new Set();

    for (let i = 1; i < trs.length; i++) {
        let cells = trs[i].getElementsByTagName('td');
        let maKHCell = cells[1].innerText;
        let soContCell = cells[3].innerText;
        let ngayGhiSoCell = cells[2].innerText;

        if (maKHCell === maKHSelect.value) {
            soContOptions.add(soContCell);
            ngayGhiSoOptions.add(ngayGhiSoCell);
        }
    }

    soContSelect.innerHTML = '<option value="">Chọn</option>';
    ngayGhiSoSelect.innerHTML = '<option value="">Chọn</option>';

    soContOptions.forEach(option => {
        soContSelect.innerHTML +=
            `<option value="${option}">${option}</option>`;
    });

    ngayGhiSoOptions.forEach(option => {
        ngayGhiSoSelect.innerHTML +=
            `<option value="${option}">${option}</option>`;
    });
}



function exportToPDF() {
    let docDefinition = {
        content: []
    };
    let table = document.getElementById('myTable');
    let rows = table.querySelectorAll('tr');

    rows.forEach(row => {
        let cells = row.querySelectorAll('th, td');
        let dataRow = [];
        cells.forEach(cell => {
            dataRow.push(cell.innerText);
        });
        docDefinition.content.push(dataRow);
    });

    pdfMake.createPdf(docDefinition).download('table.pdf');
}

function exportSelectedRowsToExcel() {
    const selectedRows = [];
    const checkboxes = document.querySelectorAll('.rowselect:checked');

    checkboxes.forEach(checkbox => {
        selectedRows.push(parseInt(checkbox.value));
    });

    if (selectedRows.length === 0) {
        const totalRows = document.querySelectorAll('#myTable tbody tr').length;
        for (let i = 0; i < totalRows; i++) {
            selectedRows.push(i);
        }
    }

    const headers = [
        ["MÃ KH", "Ngày ghi sổ", "Số cont", "Điểm Đi", "Điểm Đến", "Loại Cont", "Mooc", "Lương Chuyến", "Phí", "", "","","","", "Số Xe","Tên", "Ứng", "Quyết Toán"],
        ["", "", "", "", "", "", "", "", "Ngoài Tỉnh", "Cặp", "Neo", "Lạnh", "Điện Thoại", "Khác","", "","",""]
    ];

    const table = document.getElementById('myTable');
    const rows = Array.from(table.querySelectorAll('tbody tr')).map((tr, index) => {
        if (selectedRows.includes(index)) {
            const ma_kh = tr.querySelector('td:nth-child(2) a').textContent.trim();
            const cells = tr.cells;
            return [
                ma_kh, // MÃ KH
                cells[2].innerText.trim(), // Ngày ghi sổ
                cells[3].innerText.trim(), // Số cont
                cells[4].innerText.trim(), // Điểm lấy rỗng
                cells[5].innerText.trim(), // Điểm đóng hàng
                cells[6].innerText.trim(), // Điểm giao hàng
                cells[7].innerText.trim(), // Giá vận chuyển
                cells[8].innerText.trim(), // VAT
                cells[9].innerText.trim(), // Phí nâng
                cells[10].innerText.trim(), // Phí hạ
                cells[11].innerText.trim(), // Phí khác
                cells[12].innerText.trim(), // Phải thu
                cells[13].innerText.trim(), // Phải thu
                cells[14].innerText.trim(), // Phải thu
                cells[15].innerText.trim(), // Phải thu
                cells[16].innerText.trim(), // Phải thu
                cells[17].innerText.trim(), // Phải thu
                cells[18].innerText.trim(), 
              
            ];
        }
    }).filter(row => row !== undefined);
    let customerName = "";
    if (rows.length > 0) {
        customerName = rows[0][15]; // First column of the first selected row
    }
    let soxe = "";
    if (rows.length > 0) {
        soxe = rows[0][14];
    }  
    let datetime="";
    if (rows.length > 0) {
        let [_, month, year] = rows[0][1].split('/');
        datetime = `${month}/${year}`;
    }

    const titles = [
        ["CÔNG TY TNHH TIẾP VẬN TÍN PHÁT"],
        ["Địa chỉ : 25/18/25 Nguyễn Minh Châu, phường Phú Trung, Quận Tân Phú, TP.HCM"],
        ["MST : 0314 715 231"],
        [`Phiếu Lương: ${customerName} - ${soxe} / (Tháng ${datetime} )`],
        [],
        []
    ];

    const totalCols = headers[0].length;
    const lastCols = [
        totalCols - 11, // Ngoài Tỉnh
        totalCols - 10, // Lương Chuyến
        totalCols - 9, // Số Xe
        totalCols - 8, // Ứng
        totalCols - 7, // Quyết Toán
        totalCols - 6, // Ngoài Quận
        totalCols - 5, // Cặp
        totalCols - 2, // Lạnh
        totalCols - 1, // Điện Thoại
        
    ];
    let totalValues = Array(totalCols).fill(0);
    
    for (let i = 0; i < rows.length; i++) {
        for (let j = 0; j < totalCols; j++) {
            if (lastCols.includes(j)) {
                totalValues[j] += parseFloat(rows[i][j].replace(/,/g, ""));
            }
        }
    }

    const totalRow = Array(totalCols).fill("");
    totalRow[0] = "Tổng cộng";
    for (let i = 0; i < lastCols.length; i++) {
        if (lastCols[i] !== totalCols - 12) {
            totalRow[lastCols[i]] = totalValues[lastCols[i]].toFixed(0).replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
        }
    }

  // Helper function to format numbers with commas
const formatNumber = (number) => {
    return number.toFixed(0).replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
};

// Helper function to create a row with label and value
const createRow = (label, value, totalCols) => {
    const row = Array(totalCols).fill("");
    row[13] = label;
    row[14] = formatNumber(value);
    return row;
};

// Extracting BHXH value
const valueBhxh = document.querySelector('#bhxh').innerText;
const bhxhValue = parseFloat(valueBhxh.replace(/,/g, ""));

// Calculating total values for specific columns
const totalLuong = [totalValues[totalCols - 11], totalValues[totalCols - 10], totalValues[totalCols - 9], totalValues[totalCols - 8], totalValues[totalCols - 7], totalValues[totalCols - 6], totalValues[totalCols - 5]].reduce((a, b) => a + b, 0);
const hoanUng = totalValues[totalCols - 2] - totalValues[totalCols - 1];
const conLai = totalLuong - hoanUng - bhxhValue;

// Creating rows
const totalTongLuong = createRow("Tổng Lương", totalLuong, totalCols);
const totalHoanUng = createRow("Hoàn Ứng", hoanUng, totalCols);
const totalBhxh = createRow("BHXH", bhxhValue, totalCols);
const totalConLai = createRow("Còn Lại", conLai, totalCols);

// Merging all data into final array
const data = [...titles, ...headers, ...rows, totalRow,, totalTongLuong, totalHoanUng, totalBhxh, totalConLai];



    const wb = XLSX.utils.book_new();
    const ws = XLSX.utils.aoa_to_sheet(data);

    ws['!merges'] = [
        { s: { r: 0, c: 0 }, e: { r: 0, c: 14 } }, // Merge title row 1
        { s: { r: 1, c: 0 }, e: { r: 1, c: 14 } }, // Merge title row 2
        { s: { r: 2, c: 0 }, e: { r: 2, c: 14 } }, // Merge title row 3
        { s: { r: 3, c: 0 }, e: { r: 3, c: 14 } }, // Merge title row 4
        { s: { r: 4, c: 0 }, e: { r: 4, c: 15 } }, // Merge title row 5
        { s: { r: 6, c: 8 }, e: { r: 6, c: 13 } }  // Merge "CHI HỘ" header
    ];

    for (let i = 0; i < 5; i++) {
        const cellAddress = XLSX.utils.encode_cell({ r: i, c: 0 });
        if (!ws[cellAddress]) ws[cellAddress] = {};
        ws[cellAddress].s = {
            font: { bold: true, sz: 14 },
            alignment: { horizontal: 'center', vertical: 'center' }
        };
    }

    const headerRow1 = 6;
    const headerRow2 = 7;
    headers[0].forEach((header, colIdx) => {
        const cellAddress = XLSX.utils.encode_cell({ r: headerRow1, c: colIdx });
        if (!ws[cellAddress]) ws[cellAddress] = {};
        ws[cellAddress].s = {
            fill: { patternType: 'solid', fgColor: { rgb: "A9D08E" } }, // Green background
            font: { bold: true },
            alignment: { horizontal: 'center', vertical: 'center' }
        };
    });

    headers[1].forEach((header, colIdx) => {
        const cellAddress = XLSX.utils.encode_cell({ r: headerRow2, c: colIdx });
        if (!ws[cellAddress]) ws[cellAddress] = {};
        ws[cellAddress].s = {
            fill: { fgColor: { rgb: "A9D08E" } }, // Green background
            font: { bold: true },
            alignment: { horizontal: 'center', vertical: 'center' }
        };
    });

    headers[1].forEach((header, colIdx) => {
        if (header === "") {
            const startCell = XLSX.utils.encode_cell({ r: headerRow1, c: colIdx });
            const endCell = XLSX.utils.encode_cell({ r: headerRow2, c: colIdx });
            ws['!merges'].push({ s: { r: headerRow1, c: colIdx }, e: { r: headerRow2, c: colIdx } });
            if (!ws[startCell]) ws[startCell] = {};
            ws[startCell].s = {
                alignment: { horizontal: 'center', vertical: 'center' }
            };
        }
    });

    XLSX.utils.book_append_sheet(wb, ws, 'SelectedRows');
    XLSX.writeFile(wb,  `Phiếu Lương - ${customerName} - ${soxe} / (${datetime}).xlsx`);
}

function printTable() {
    const printContents = document.getElementById('myTable').outerHTML;
    const originalContents = document.body.innerHTML;

    document.body.innerHTML = printContents;
    window.print();
    document.body.innerHTML = originalContents;
}

// JavaScript để xử lý hiệu ứng và sự kiện khi nhấn nút






function submitForm() {
    document.getElementById("filterForm").submit();
}

function resetFilters() {
    // Lấy giá trị của tháng đã chọn
    var selectedMonth = $('#ngay_thang').val();

    // Reset các dropdown Ten_KH và So_cont
    $('#ten_kh').html('<option value="">Chọn Tên KH</option>');
    $('#so_cont').html('<option value="">Chọn Số Cont</option>');

    // Cập nhật URL để chỉ giữ lại tháng đã chọn
    var newUrl = window.location.origin + window.location.pathname;
    if (selectedMonth) {
        newUrl += '?ngay_thang=' + selectedMonth;
    }
    window.location.href = newUrl;
}

document.querySelectorAll('.truncate').forEach(function (element) {
    element.addEventListener('transitionend', function () {
        if (element.classList.contains('truncate')) {
            element.classList.remove('truncate');
        }
    });
});


$('.color-selector').click(function () {
    $('.color-options').toggle();
});
$('.color-option').click(function () {
    var color = $(this).css('background-color');
    $('.color-selected').css({ 'background-color': color, 'display': 'block' });

    $('.color-options').hide();
});



// Trong scripts.js

$(document).ready(function() {
    var selectedColor = '';

    $('.color-option').on('click', function() {
        selectedColor = $(this).css('background-color');
        $('.color-option').removeClass('selected');
        $(this).addClass('selected');
    });

    $('tr').on('click', function() {
        var row = $(this);
        var id = row.data('id');
        var currentColor = row.css('background-color');

        if (selectedColor && currentColor === 'rgba(0, 0, 0, 0)') {
            // Apply color to row and mark it as selected
            row.css('background-color', selectedColor);
            updateRowColor(id, selectedColor);
            row.addClass('selected');
            row.find('td').css('color', 'white');
        } else if (currentColor !== 'rgba(0, 0, 0, 0)') {
            // Remove color if row is already colored and clicked again
            row.css('background-color', '');
            updateRowColor(id, ''); // Send empty color to remove from database
            row.removeClass('selected');
            row.find('td').css('color', '#64748b');
        }
    });

    $('tr').each(function() {
        var row = $(this);
        var currentColor = row.css('background-color');
        if (currentColor !== 'rgba(0, 0, 0, 0)') {
            row.find('td').css('color', 'white');
        }
    });

    $('#ngay_thang').change(function() {
        var selectedMonth = $(this).val();
        var newUrl = window.location.origin + window.location.pathname;
        if (selectedMonth) {
            newUrl += '?ngay_thang=' + selectedMonth;
        }
        window.location.href = newUrl;
    });

    $('#ten_kh').change(function() {
        updateSoCont();
    });

    function updateSoCont() {
        var selectedTenKH = $('#ten_kh').val();
        var selectedMonth = $('#ngay_thang').val();
        var soContOptions = '';

        $.ajax({
            url: 'get_so_cont.php', // Đường dẫn đến tệp PHP để lấy dữ liệu.
            method: 'POST',
            data: {
                selectedTenKH: selectedTenKH,
                selectedMonth: selectedMonth
            },
            success: function(response) {
                // Xử lý dữ liệu nhận được từ máy chủ và cập nhật dropdown So_cont.
                $('#so_cont').html('<option value="">Chọn Số Cont</option>' + response);
            },
            error: function() {
                console.error('Error updating So_cont dropdown.');
            }
        });
    }

    // Initialization code
    if (!$('#ngay_thang').val()) {
        $('#ngay_thang').val('<?php echo $current_month; ?>');
    }
});



function updateRowColor(id, color) {
    $.ajax({
        url: 'template_module/update_row_color', // Đường dẫn đến tệp PHP xử lý cập nhật màu.
        method: 'POST',
        data: {
            id: id,
            color: color,
        },
        success: function(response) {
            console.log('Color updated successfully');
        },
        error: function() {
            console.error('Error updating color');
        }
    });
}
setTimeout(function() {
    $("#success-alert").fadeOut(300, function(){
        $(this).remove();
    });
}, 3000);