<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Model_luong extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function get_luong_data()
    {
        $this->db->select('cluong.*, tblclients.company as Ten_KH');
        $this->db->from(db_prefix() . 'cluong as cluong');
        $this->db->join(db_prefix() . 'clients as tblclients', 'cluong.MA_KH = tblclients.userid', 'left');
        return $this->db->get()->result_array();
    }
  
    public function get_clients()
    {
        return $this->db->get(db_prefix() . 'clients')->result_array();
    }
    public function get_xenha()
    {
        return $this->db->get(db_prefix() . 'leads_sources')->result_array();
    }
    public function get_congno()
    {
        return $this->db->get(db_prefix() . 'congno')->result_array();
    }

    public function insert_luong($data)
    {
        $this->db->insert(db_prefix() . 'cluong', $data);
        return $this->db->insert_id();
    }

    public function update_luong($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'cluong', $data);
    }

    public function get_luong_by_id($id)
    {
        return $this->db->get_where(db_prefix() . 'cluong', array('id' => $id))->row();
    }

    public function delete_luong($id)
    {
        $this->db->delete(db_prefix() . 'cluong', array('id' => $id));
    }

    public function update_field($id, $field, $value)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'cluong', array($field => $value));
    }

    public function get_filtered_data($filter_MA_KH = '', $filter_So_cont = '')
    {
        $this->db->select('cluong.*, tblclients.company as Ten_KH');
        $this->db->from(db_prefix() . 'cluong as luong');
        $this->db->join(db_prefix() . 'clients as tblclients', 'cluong.MA_KH = tblclients.userid', 'left');

        if (!empty($filter_MA_KH)) {
            $this->db->where('cluong.MA_KH', $filter_MA_KH);
        }

        if (!empty($filter_So_cont)) {
            $this->db->where('cluong.So_cont', $filter_So_cont);
        }

        return $this->db->get()->result_array();
    }
    public function get_staff_data()
    {
        return $this->db->get(db_prefix() . 'staff')->result_array();
    }
   

}
