

const exportBtn = document.getElementById('export-btn');

const exportMenu = document.getElementById('export-menu');

const togglefilter = document.getElementById('toggleFilterBtn');

const filterForm = document.getElementById('filterContainer');

exportBtn.addEventListener('click', function () {

    exportMenu.style.display = exportMenu.style.display === 'none' ?

        'block' : 'none';

});

togglefilter.addEventListener('click', function () {

    filterForm.classList.toggle('show');

})

document.addEventListener('click', function (event) {

    const isClickInsideExportBtn = exportBtn.contains(event.target);

    const isClickInsideExportMenu = exportMenu.contains(event

        .target);



    if (!isClickInsideExportBtn && !isClickInsideExportMenu) {

        exportMenu.style.display = 'none';

    }

});

document.addEventListener('click', function (event) {

    const isClickInsideFilterBtn = togglefilter.contains(event

        .target);

    const isClickInsideFilterForm = filterForm.contains(event

        .target);

    if (!isClickInsideFilterBtn && !isClickInsideFilterForm) {

        filterForm.classList.remove('show');

    }

});





document.addEventListener("DOMContentLoaded", function () {

    // Set default month to the current month

    var currentMonth = ("0" + (new Date().getMonth() + 1)).slice(-2);

    document.getElementById("filter_Thang").value = currentMonth;



    // Trigger the filter function on page load

    filterTable();

});



function filterTable() {

    var filterMAKH = document.getElementById("filter_MA_KH").value.toUpperCase();

    var filterSoCont = document.getElementById("filter_nha_xe").value.toUpperCase();

    var filterNgayGhiSo = document.getElementById("filter_Ngay_ghi_so").value.toUpperCase();

    var filterThang = document.getElementById("filter_Thang").value;



    var table = document.getElementById("myTable");

    var tr = table.getElementsByTagName("tr");



    for (var i = 1; i < tr.length; i++) {

        var tdMAKH = tr[i].getElementsByTagName("td")[1];

        var tdSoCont = tr[i].getElementsByTagName("td")[3];

        var tdNgayGhiSo = tr[i].getElementsByTagName("td")[2];



        if (tdMAKH && tdSoCont && tdNgayGhiSo) {

            var txtValueMAKH = tdMAKH.textContent || tdMAKH.innerText;

            var txtValueSoCont = tdSoCont.textContent || tdSoCont.innerText;

            var txtValueNgayGhiSo = tdNgayGhiSo.textContent || tdNgayGhiSo.innerText;



            var date = new Date(txtValueNgayGhiSo);

            var month = ("0" + (date.getMonth() + 1)).slice(-2);



            if ((txtValueMAKH.toUpperCase().indexOf(filterMAKH) > -1 || filterMAKH === "") &&

                (txtValueSoCont.toUpperCase().indexOf(filterSoCont) > -1 || filterSoCont === "") &&

                (txtValueNgayGhiSo.toUpperCase().indexOf(filterNgayGhiSo) > -1 || filterNgayGhiSo === "") &&

                (month === filterThang || filterThang === "")) {

                tr[i].style.display = "";

            } else {

                tr[i].style.display = "none";

            }

        }

    }

}



function searchTable() {

    let input = document.getElementById('searchInput').value.toLowerCase();

    let table = document.getElementById('myTable');

    let trs = table.getElementsByTagName('tr');



    for (let i = 1; i < trs.length; i++) {

        let tds = trs[i].getElementsByTagName('td');

        let rowContainsSearchTerm = false;



        for (let j = 0; j < tds.length; j++) {

            if (tds[j].innerText.toLowerCase().includes(input)) {

                rowContainsSearchTerm = true;

                break;

            }

        }



        if (rowContainsSearchTerm) {

            trs[i].style.display = "";

        } else {

            trs[i].style.display = "none";

        }

    }

}



function updateFilters() {

    let maKHSelect = document.getElementById('filter_MA_KH');

    let soContSelect = document.getElementById('filter_nha_xe');

    let ngayGhiSoSelect = document.getElementById('filter_Ngay_ghi_so');

    let table = document.getElementById('myTable');

    let trs = table.getElementsByTagName('tr');



    let soContOptions = new Set();

    let ngayGhiSoOptions = new Set();



    for (let i = 1; i < trs.length; i++) {

        let cells = trs[i].getElementsByTagName('td');

        let maKHCell = cells[1].innerText;

        let soContCell = cells[3].innerText;

        let ngayGhiSoCell = cells[2].innerText;



        if (maKHCell === maKHSelect.value) {

            soContOptions.add(soContCell);

            ngayGhiSoOptions.add(ngayGhiSoCell);

        }

    }



    soContSelect.innerHTML = '<option value="">Chọn</option>';

    ngayGhiSoSelect.innerHTML = '<option value="">Chọn</option>';



    soContOptions.forEach(option => {

        soContSelect.innerHTML +=

            `<option value="${option}">${option}</option>`;

    });



    ngayGhiSoOptions.forEach(option => {

        ngayGhiSoSelect.innerHTML +=

            `<option value="${option}">${option}</option>`;

    });

}





function exportToPDF() {

    const table = document.getElementById('myTable');

    const rows = Array.from(table.querySelectorAll('tr'));



    const docDefinition = {

        content: [

            {

                table: {

                    headerRows: 1,

                    widths: Array(21).fill('*'), // Adjust column width here if needed

                    body: [

                        [

                            {text: 'STT', style: 'tableHeader'},

                            {text: 'Ngày ghi sổ', style: 'tableHeader'},

                            {text: 'Số cont', style: 'tableHeader'},

                            {text: 'Điểm lấy rỗng', style: 'tableHeader'},

                            {text: 'Điểm đóng hàng', style: 'tableHeader'},

                            {text: 'Điểm giao hàng', style: 'tableHeader'},

                            {text: 'Giá vận chuyển', style: 'tableHeader'},

                            {text: 'VAT', style: 'tableHeader'},

                            {text: 'CHI HỘ', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                            {text: 'Phải thu', style: 'tableHeader'},

                            {text: 'SỐ XE', style: 'tableHeader'},

                            {text: 'TÀI XẾ', style: 'tableHeader'},

                            {text: 'Ghi chú', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                            {text: 'Phí nâng', style: 'tableHeader'},

                            {text: 'Phí hạ', style: 'tableHeader'},

                            {text: 'Phí khác', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                            {text: '', style: 'tableHeader'},

                        ]

                    ].concat(

                        rows.map((row, index) => {

                            const cells = Array.from(row.querySelectorAll('th, td'));

                            return [

                                {text: index + 1, style: 'tableBody'},

                                ...cells.map(cell => ({text: cell.innerText, style: 'tableBody'}))

                            ];

                        })

                    )

                }

            }

        ],

        styles: {

            tableHeader: {

                bold: true,

                fontSize: 12,

                fillColor: '#f2f2f2',

                alignment: 'center'

            },

            tableBody: {

                fontSize: 10,

                alignment: 'center'

            }

        }

    };



    pdfMake.createPdf(docDefinition).download('table.pdf');

}





function exportSelectedRowsToExcel() {

    // --- 1. LẤY CÁC DÒNG ĐƯỢC CHỌN ---
    const selectedRowValues = [];
    const checkboxes = document.querySelectorAll('.rowselect:checked');
    checkboxes.forEach(checkbox => {
        selectedRowValues.push(checkbox.value);
    });

    let exportAll = selectedRowValues.length === 0;
    
    const table = document.getElementById('myTable');
    const allHtmlRows = Array.from(table.querySelectorAll('tbody tr'));
    
    if (allHtmlRows.length === 0) {
        console.warn("Bảng không có dữ liệu để xuất.");
        return;
    }

    // --- 2. KIỂM TRA QUYỀN HIỂN THỊ CỘT CHI PHÍ ---
    // Kiểm tra số lượng cột ở dòng đầu tiên để xác định xem các cột chi phí có tồn tại không.
    // Giả sử nếu có đầy đủ cột thì length sẽ lớn hơn 29.
    const hasCostColumns = allHtmlRows[0].cells.length > 29;

    // --- 3. ĐỊNH NGHĨA CẤU TRÚC HEADER ĐỘNG ---
    let baseHeaders = [
        "MÃ KH", "Ngày ghi sổ", "Số cont", "Điểm lấy rỗng", "Điểm đóng hàng", "Điểm giao hàng", "Xuất Nhập", "Loại Cont", "Giá vận chuyển", "VAT", "CHI HỘ", "", "", "", "", "", "", "", "Phải thu", "Đã Thu", "Thuê Xe Ngoài", "", "Xe Nhà", "", "Chi Phí Phát Sinh", "Hoa Hồng", "Tổng Chi Phí", "Ghi chú"
    ];
    let baseSubHeaders = [
        "", "", "", "", "", "", "", "", "", "", "Phí Bốc Xếp", "Phí nâng", "Phí hạ", "Vệ Sinh", "Cân", "Cược cont", "Neo", "Phí khác", "", "", "Nhà Xe", "Giá", "Tên", "Số Xe", "", "", "", ""
    ];

    if (hasCostColumns) {
        baseHeaders.push("CHI PHÍ", "", "", "TỔNG CỘNG");
        baseSubHeaders.push("Tên Chi Phí", "Số Tiền", "Ghi Chú", "");
    }

    const headers = [baseHeaders, baseSubHeaders];
    const totalCols = headers[0].length;

    // --- 4. TRÍCH XUẤT VÀ ÁNH XẠ DỮ LIỆU TỪ BẢNG HTML ---
    const parseCurrency = (value) => parseFloat(String(value).replace(/,/g, "")) || 0;

    const rows = allHtmlRows
        .filter(tr => {
            if (exportAll) return true;
            const checkbox = tr.querySelector('.rowselect');
            return checkbox && selectedRowValues.includes(checkbox.value);
        })
        .map(tr => {
            const cells = tr.cells;
            let rowData = [
                cells[1]?.querySelector('a')?.textContent.trim() || cells[1]?.innerText.trim() || '', // MÃ KH
                cells[3]?.innerText.trim() || '', // Ngày ghi sổ
                cells[2]?.innerText.trim() || '', // Số cont
                cells[4]?.innerText.trim() || '', // Điểm lấy rỗng
                cells[5]?.innerText.trim() || '', // Điểm đóng hàng
                cells[6]?.innerText.trim() || '', // Điểm giao hàng
                cells[7]?.innerText.trim() || '', // Xuất Nhập
                cells[8]?.innerText.trim() || '', // Loại Cont
                cells[10]?.innerText.trim() || '',// Giá vận chuyển
                cells[9]?.innerText.trim() || '', // VAT
                cells[11]?.innerText.trim() || '',// Phí Bốc Xếp
                cells[12]?.innerText.trim() || '',// Phí nâng
                cells[13]?.innerText.trim() || '',// Phí hạ
                cells[14]?.innerText.trim() || '',// Vệ Sinh
                cells[15]?.innerText.trim() || '',// Cân
                cells[16]?.innerText.trim() || '',// Cược cont
                cells[17]?.innerText.trim() || '',// Neo
                cells[18]?.innerText.trim() || '',// Phí khác
                cells[19]?.innerText.trim() || '',// Phải thu
                cells[20]?.innerText.trim() || '',// Đã Thu
                cells[21]?.innerText.trim() || '',// Thuê Xe Ngoài - Nhà Xe
                cells[22]?.innerText.trim() || '',// Thuê Xe Ngoài - Giá
                cells[23]?.innerText.trim() || '',// Xe Nhà - Tên
                cells[24]?.innerText.trim() || '',// Xe Nhà - Số Xe
                cells[25]?.innerText.trim() || '',// Chi Phí Phát Sinh
                cells[26]?.innerText.trim() || '',// Hoa Hồng
                cells[27]?.innerText.trim() || '',// Tổng Chi Phí
                cells[28]?.innerText.trim() || '' // Ghi chú
            ];

            if (hasCostColumns) {
                const tongChiPhi = parseCurrency(cells[27]?.innerText.trim() || '0');
                const soTienChiPhi = parseCurrency(cells[30]?.innerText.trim() || '0'); 
                const tongCong = tongChiPhi + soTienChiPhi;
                
                rowData.push(
                cells[29]?.innerText.trim() || '', // Tên Chi Phí
                cells[30]?.innerText.trim() || '', // Số Tiền (của Chi Phí)
                cells[31]?.innerText.trim() || '', // Ghi Chú (của Chi Phí)
                tongCong
                );
            }
            return rowData;
        });

    if (rows.length === 0) {
        console.warn("Không có dòng nào được chọn hoặc bảng trống.");
        return;
    }


    // --- 5. CHUẨN BỊ TIÊU ĐỀ VÀ THÔNG TIN FILE ---
    let customerName = rows[0][0] || "Chung";
    let datetime = "";
    if (rows[0][1]) {
        let parts = rows[0][1].split('/');
        if (parts.length === 3) datetime = `${parts[1]}/${parts[2]}`;
    }

    const titles = [
        ["CÔNG TY TNHH TIẾP VẬN TÍN PHÁT"],
        ["Địa chỉ : 25/18/25 Nguyễn Minh Châu, phường Phú Trung, Quận Tân Phú, TP.HCM"],
        ["MST : 0314 715 231"],
        [`SỔ CHI TIẾT CÔNG NỢ - ${customerName} (Tháng ${datetime})`],
        [], // Dòng trống
    ];


    // --- 6. TÍNH TOÁN CÁC DÒNG TỔNG KẾT ---
    let colsToSumIndices = [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 24, 25, 26];
    if (hasCostColumns) {
        // Chỉ mục của "Số Tiền" và "TỔNG CỘNG"
        colsToSumIndices.push(29, 31); 
    }
    const chiHoColsIndices = [10, 11, 12, 13, 14, 15, 16, 17];
    
    let totalValues = Array(totalCols).fill(0);
    rows.forEach(row => {
        colsToSumIndices.forEach(colIndex => {
            if (row[colIndex] !== undefined) {
                 totalValues[colIndex] += parseCurrency(row[colIndex]);
            }
        });
    });

    let totalChiHo = 0;
    rows.forEach(row => {
        chiHoColsIndices.forEach(colIndex => {
            if(row[colIndex] !== undefined) {
                 totalChiHo += parseCurrency(row[colIndex]);
            }
        });
    });

    const formatCurrency = (number) => number.toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g, ",");

    const totalRow = Array(totalCols).fill("");
    totalRow[0] = "Tổng cộng";
    colsToSumIndices.forEach(colIndex => {
        totalRow[colIndex] = formatCurrency(totalValues[colIndex]);
    });

    const summaryRows = [
        [], // Dòng trống
        Object.assign(Array(totalCols).fill(""), { 0: "Tổng vận chuyển", 18: formatCurrency(totalValues[8]) }),
        Object.assign(Array(totalCols).fill(""), { 0: "Tổng chi hộ", 18: formatCurrency(totalChiHo) }),
        Object.assign(Array(totalCols).fill(""), { 0: "Tạm Ứng" }),
        Object.assign(Array(totalCols).fill(""), { 0: "Còn Lại" })
    ];


    // --- 7. TẠO FILE EXCEL VỚI XLSX ---
    const data = [...titles, headers[0], headers[1], ...rows, totalRow, ...summaryRows];
    const ws = XLSX.utils.aoa_to_sheet(data, { cellStyles: true });

    let merges = [
        ...[0, 1, 2, 3].map(r => ({ s: { r: r, c: 0 }, e: { r: r, c: totalCols - 1 } })),
        { s: { r: 5, c: 10 }, e: { r: 5, c: 17 } }, // CHI HỘ
        { s: { r: 5, c: 20 }, e: { r: 5, c: 21 } }, // Thuê Xe Ngoài
        { s: { r: 5, c: 22 }, e: { r: 5, c: 23 } }, // Xe Nhà
    ];
    
    if (hasCostColumns) {
        merges.push({ s: { r: 5, c: 28 }, e: { r: 5, c: 30 } }); // CHI PHÍ
    }
    ws['!merges'] = merges;

    headers[1].forEach((h, c) => {
        if (h === "") ws['!merges'].push({ s: { r: 5, c: c }, e: { r: 6, c: c } });
    });

    const headerStyle = {
        fill: { fgColor: { rgb: "A9D08E" } },
        font: { bold: true, color: { rgb: "000000" } },
        alignment: { horizontal: 'center', vertical: 'center' },
        border: { top: { style: "thin" }, bottom: { style: "thin" }, left: { style: "thin" }, right: { style: "thin" } }
    };
    const titleStyle = {
        font: { bold: true, sz: 14 },
        alignment: { horizontal: 'center', vertical: 'center' }
    };
    
    for (let r = 0; r < titles.length - 1; r++) {
       const cellAddress = XLSX.utils.encode_cell({ r: r, c: 0 });
       if (!ws[cellAddress]) ws[cellAddress] = {v: titles[r][0]};
       ws[cellAddress].s = titleStyle;
    }

    for (let c = 0; c < totalCols; c++) {
        let cellAddress1 = XLSX.utils.encode_cell({ r: 5, c: c });
        if (!ws[cellAddress1]) ws[cellAddress1] = {};
        ws[cellAddress1].s = headerStyle;
        let cellAddress2 = XLSX.utils.encode_cell({ r: 6, c: c });
        if (!ws[cellAddress2]) ws[cellAddress2] = {};
        ws[cellAddress2].s = headerStyle;
    }
    
    ws['!cols'] = headers[0].map(() => ({ wch: 15 }));

    const wb = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(wb, ws, 'SoCongNo');
    XLSX.writeFile(wb, `Sổ Chi Tiết Công Nợ - ${customerName} (Tháng ${datetime}).xlsx`);
}



function printTable() {

    const printContents = document.getElementById('myTable').outerHTML;

    const originalContents = document.body.innerHTML;



    document.body.innerHTML = printContents;

    window.print();

    document.body.innerHTML = originalContents;

}



// JavaScript để xử lý hiệu ứng và sự kiện khi nhấn nút

document.addEventListener('DOMContentLoaded', function () {

    var formContainer = document.querySelector('.form-container');

    var addButton = document.querySelector('#add-button');



    addButton.addEventListener('click', function () {

        formContainer.classList.toggle('show');

        formContainer.style.display = 'block';

    });

});











function submitForm() {

    document.getElementById("filterForm").submit();

}



function resetFilters() {

    // Lấy giá trị của tháng đã chọn

    var selectedMonth = $('#ngay_thang').val();

    var records_per_page = $('#recordsPerPage').val();



    // Reset các dropdown Ten_KH và nha_xe

    $('#ten_kh').html('<option value="">Chọn Tên KH</option>');

    $('#nha_xe').html('<option value="">Chọn Số Cont</option>');



    // Cập nhật URL để chỉ giữ lại tháng đã chọn

    var newUrl = window.location.origin + window.location.pathname;

    if (selectedMonth) {

        newUrl += '?ngay_thang=' + selectedMonth + '&records_per_page=' + records_per_page;

    }

    window.location.href = newUrl;

}



document.querySelectorAll('.truncate').forEach(function (element) {

    element.addEventListener('transitionend', function () {

        if (element.classList.contains('truncate')) {

            element.classList.remove('truncate');

        }

    });

});





$('.color-selector').click(function () {

    $('.color-options').toggle();

});

$('.color-option').click(function () {

    var color = $(this).css('background-color');

    $('.color-selected').css({ 'background-color': color, 'display': 'block' });



    $('.color-options').hide();

});







// Trong scripts.js



$(document).ready(function() {

    var selectedColor = '';



    $('.color-option').on('click', function() {

        selectedColor = $(this).css('background-color');

        $('.color-option').removeClass('selected');

        $(this).addClass('selected');

    });



    $('tr').on('click', function() {

        var row = $(this);

        var id = row.data('id');

        var currentColor = row.css('background-color');



        if (selectedColor && currentColor === 'rgba(0, 0, 0, 0)') {

            // Apply color to row and mark it as selected

            row.css('background-color', selectedColor);

            updateRowColor(id, selectedColor);

            row.addClass('selected');

            row.find('td').css('color', 'white');

        } else if (currentColor !== 'rgba(0, 0, 0, 0)') {

            // Remove color if row is already colored and clicked again

            row.css('background-color', '');

            updateRowColor(id, ''); // Send empty color to remove from database

            row.removeClass('selected');

            row.find('td').css('color', '#64748b');

        }

    });



    $('tr').each(function() {

        var row = $(this);

        var currentColor = row.css('background-color');

        if (currentColor !== 'rgba(0, 0, 0, 0)') {

            row.find('td').css('color', 'white');

        }

    });







    $('#ten_kh').change(function() {

        updateSoCont();

    });



    function updateSoCont() {

        var selectedTenKH = $('#ten_kh').val();

        var selectedMonth = $('#ngay_thang').val();

        var soContOptions = '';



        $.ajax({

            url: 'get_nha_xe.php', // Đường dẫn đến tệp PHP để lấy dữ liệu.

            method: 'POST',

            data: {

                selectedTenKH: selectedTenKH,

                selectedMonth: selectedMonth

            },

            success: function(response) {

                // Xử lý dữ liệu nhận được từ máy chủ và cập nhật dropdown nha_xe.

                $('#nha_xe').html('<option value="">Chọn Số Cont</option>' + response);

            },

            error: function() {

                console.error('Error updating nha_xe dropdown.');

            }

        });

    }



    // Initialization code

    if (!$('#ngay_thang').val()) {

        $('#ngay_thang').val('<?php echo $current_month; ?>');

    }

});



function updateRowColor(id, color) {

    $.ajax({

        url: 'template_module1/update_row_color', // Đường dẫn đến tệp PHP xử lý cập nhật màu.

        method: 'POST',

        data: {

            id: id,

            color: color,

        },

        success: function(response) {

            console.log('Color updated successfully');

        },

        error: function() {

            console.error('Error updating color');

        }

    });

}

setTimeout(function() {

    $("#success-alert").fadeOut(300, function(){

        $(this).remove();

    });

}, 3000);