<?php

defined('BASEPATH') or exit('No direct script access allowed');



class Template_module1 extends AdminController

{

    public function __construct()

    {

        parent::__construct();

        $this->load->model('template_module1_model');

    }



    public function index()

    {

        $staff_id = get_staff_user_id();

        $staff = $this->staff_model->get($staff_id);

        $role = $staff->role;

        $data['status'] = $this->template_module1_model->get_status();

        $data['clients'] = $this->template_module1_model->get_clients();

        $data['congno_data'] = $this->template_module1_model->get_congno_data();

        foreach ($data['congno_data'] as &$row) {
        $row['expenses'] = $this->template_module1_model->get_expense_by_congno($row['id']);
        }

        $data['staff'] = $this->template_module1_model->get_staff_data();

        $data['xenha'] = $this->template_module1_model->get_xenha();

        if ($role == 4) {

            foreach ($data['congno_data'] as &$row) {

                $row['Gia_van_chuyen'] = 0;

            }

            $data['hide_shipping_cost'] = true;

        } else {

            $data['hide_shipping_cost'] = false;

        }

        $this->load->view('manage', $data);

    }

    public function get_congno($id)

    {

    $congno = $this->template_module1_model->get_congno_by_id($id);
    if ($congno) {
        $congno->expenses = $this->template_module1_model->get_expense_by_congno($id);
        echo json_encode($congno);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Không tìm thấy dữ liệu công nợ']);
    }

    }
  
    public function get_xenha($id)

    {

        $xenha = $this->template_module1_model->get_xenha_by_id($id);

        echo json_encode($xenha);

    }
   
  public function insert_congno() {
    $data = $this->input->post();
    if (is_admin()) {
        $expense_data = array(
            'expense_name' => $this->input->post('expense_name'),
            'amount'       => $this->input->post('amount'),
            'note'         => $this->input->post('note')
        );
        // Loại bỏ các trường này khỏi $data trước khi insert vào bảng công nợ
        unset($data['expense_name'], $data['amount'], $data['note']);
        }

        // Insert công nợ
        $this->template_module1_model->insert_congno($data);
        $congno_id = $this->db->insert_id();

        // Nếu là admin thì insert expense
        if (is_admin() && !empty($expense_data['expense_name'])) {
            $expense_data['congno_id'] = $congno_id;
            $this->template_module1_model->insert_expense($expense_data);
        }

        redirect('template_module1/index');
    }




public function update_congno()
{
    $id = $this->input->post('id');
    $congno_data = $this->input->post();

    if (is_admin()) {
        $expense_data = [
            'expense_name' => $congno_data['expense_name'] ?? '',
            'amount'       => $congno_data['amount'] ?? 0,
            'note'         => $congno_data['note'] ?? '',
            'congno_id'    => $id
        ];
        unset($congno_data['expense_name'], $congno_data['amount'], $congno_data['note']);
    }

    $this->template_module1_model->update_congno_data($id, $congno_data);

    if (is_admin()) {
        $existing = $this->template_module1_model->get_expense_by_congno($id);
        if (!empty($existing)) {
            $this->template_module1_model->update_expense_data($existing[0]['id'], $expense_data);
        } else {
            $this->template_module1_model->insert_expense($expense_data);
        }
    }

    echo json_encode(['status' => 'success']);
}





    public function delete($id)

    {

        $this->template_module1_model->delete_congno($id);

        redirect('template_module1/index');

    }

    public function update_row_color()

    {

        $id = $this->input->post('id');

        $color = $this->input->post('color');

    

        $this->template_module1_model->update_field($id, 'note_color', $color);

        $csrf_hash = $this->security->get_csrf_hash(); // Lấy mã thông báo CSRF mới

    

        echo json_encode(['status' => 'success', 'csrfHash' => $csrf_hash]);

    }

    

    public function delete_selected()

    {

        $selectedIds = $this->input->post('ids');

        foreach ($selectedIds as $id) {

            $this->template_module1_model->delete_congno($id);

        }



        $response = ['status' => 'success'];

        echo json_encode($response);

    }

    

    

}